% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_analysis.R
\name{summary.queue_df}
\alias{summary.queue_df}
\title{Compute resource statistics from queue_df object}
\usage{
\method{summary}{queue_df}(object, ...)
}
\arguments{
\item{object}{an object of class \code{queue_df}, the result of a call to \code{queue_step}.}

\item{...}{futher arguments to be passed to or from other methods.}
}
\value{
A list of performance statistics for the queue. "Mean waiting time": The mean time each customer had to wait in queue for service. "Mean response time": The mean time that each customer spends in the system (departure time - arrival time). "Utilization factor": The ratio of available time for all servers and time all servers were used. It can be greater than one if a customer arrives near the end of a shift and keeps a server busy. "Queue Lengths" and "System Lengths", the proportion of time for each queue length or number of customers in the system.
}
\description{
Compute resource statistics from queue_df object
}
\examples{
set.seed(1L)
n_customers <- 100
arrival_df <- data.frame(ID = c(1:n_customers), times = rlnorm(n_customers, meanlog = 3))
service <- rexp(n_customers)
queue <- queue_step(arrival_df = arrival_df, service = service)
summary(queue)

}

