% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_x.R
\name{reg_x}
\alias{reg_x}
\title{Build regression models only one dependent variable}
\usage{
reg_x(data = NULL, x = NULL, y = NULL, cov = NULL, factors = NULL,
  model = NULL, time = NULL, cov_show = FALSE, detail_show = FALSE,
  confint_glm = "default", save_to_file = NULL)
}
\arguments{
\item{data}{A data.frame to build the regression model.}

\item{x}{Integer column indices or names of the variables to be included in univariate analysis. If \code{NULL}, the default columns are all the variables except `y`, `time` and `cov`.}

\item{y}{Integer column indice or name of dependent variable, only one integer or character}

\item{cov}{Integer column indices or name of covariate variables}

\item{factors}{Integer column indices or names of variables to be treated as factor}

\item{model}{regression model, see \code{\link{lm}}, \code{\link{glm}}, \code{\link[survival]{coxph}} for more details}

\item{time}{Integer column indices  or name of survival time, used in cox regression, see \code{\link[survival]{coxph}} for more details}

\item{cov_show}{A logical, whether to create covariates result, default FALSE}

\item{detail_show}{A logical, whether to create each regression result, default FALSE. If TRUE, with many regressions, the return result could be very large.}

\item{confint_glm}{A character, 'default' or 'profile'. The default method for 'glm' class to compute confidence intervals assumes asymptotic normality \code{\link[stats]{confint}}, you can also use profile likelihood method \code{\link[MASS]{confint.glm}}, but it is pretty slow.
In this case you could specify 'default' for speed.}

\item{save_to_file}{A character, containing file name or path}
}
\value{
If detail_show is TRUE, the return result is a list including two components, the first part is a detailed analysis result, the second part is a concentrated result in a  data.frame. Otherwise, only return concentrated result in a  data.frame.
}
\description{
Build general linear model, generalized linear model, cox regression model with only one dependent variables.
}
\examples{
reg_glm<-reg_x(data = diabetes, x = c(1:4, 6), y = 5, factors = c(1, 3, 4), model = 'glm')
##  other methods
fit<-reg_x(data = diabetes, x = c(1, 3:6), y = "age", factors = c(1, 3, 4), model = 'lm')
fit<-reg_x(data = diabetes, x = c( "sex","education","BMI"), y = "diabetes",
time ="age", factors = c("sex","smoking","education"), model = 'coxph')
}
