% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/any.R
\name{any_tibble}
\alias{any_tibble}
\title{Random tibble generator}
\usage{
any_tibble(rows = c(1L, 10L), cols = c(1L, 10L), frac_na = 0)
}
\arguments{
\item{rows}{Number of rows of the generated data frame.
If \code{rows} is a single number all data frames will have
this number of rows. If \code{rows} is a numeric vector of
length 2 it will produce data frames with rows between
a minimum and maximum, inclusive. For example
\code{rows = c(1L, 10L)} would produce data frames with rows
between 1 and 10.}

\item{cols}{Number of columns of the generated data frame.
If \code{cols} is a single number all data frames will have
this number of columns. If \code{cols} is a numeric vector
of length 2 it will produce data frames with columns
between a minimum and maximum, inclusive. For example
\code{cols = c(1L, 10L)} would produce data frames with
columns between 1 and 10.}

\item{frac_na}{The approximate fraction of \code{NA} values to
be included in the vector. A fraction of 0, the default,
will include no \code{NA} values. A fraction of 0.5 would
include around 50\% \code{NA} values.}
}
\value{
A \code{hedgehog.internal.gen} generator
}
\description{
Generate random tibbles.
}
\examples{
any_tibble() |> show_example()
any_tibble(rows = 10L) |> show_example()
any_tibble(cols = 5L, frac_na = 0.5) |> show_example()
}
