% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixct.R
\name{posixct_}
\alias{posixct_}
\alias{posixct_bounded}
\alias{posixct_left_bounded}
\alias{posixct_right_bounded}
\title{POSIXct generators}
\usage{
posixct_(len = 1L, frac_na = 0)

posixct_bounded(left, right, len = 1L, frac_na = 0)

posixct_left_bounded(left, len = 1L, frac_na = 0)

posixct_right_bounded(right, len = 1L, frac_na = 0)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10.}

\item{frac_na}{The approximate fraction of \code{NA} values to
be included in the vector. A fraction of 0, the default,
will include no \code{NA} values. A fraction of 0.5 would
include around 50\% \code{NA} values.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{hedgehog.internal.gen} generator
}
\description{
A set of generators for POSIXct vectors.
}
\examples{
posixct_() |> show_example()
posixct_bounded(
  left = as.POSIXct("2020-01-01 00:00:00"),
  right = as.POSIXct("2021-01-01 00:00:00")
) |> show_example()
posixct_(len = 10L, frac_na = 0.5) |> show_example()
}
