% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/for_all.R
\name{for_all}
\alias{for_all}
\title{Test properties of a function}
\usage{
for_all(
  ...,
  property,
  tests = getOption("quickcheck.tests", 100L),
  shrinks = getOption("quickcheck.shrinks", 100L),
  discards = getOption("quickcheck.discards", 100L)
)
}
\arguments{
\item{...}{Named generators}

\item{property}{A function which takes values from from
the generator and calls an expectation on it. This function must have
parameters matching the generator names.}

\item{tests}{The number of tests to run.}

\item{shrinks}{The maximum number of shrinks to run when
shrinking a value to find the smallest counterexample.}

\item{discards}{The maximum number of discards to permit
when running the property.}
}
\value{
A \code{testthat} expectation object.
}
\description{
Test properties of a function
}
\examples{
for_all(
  a = numeric_(len = 1L),
  b = numeric_(len = 1L),
  property = \(a, b) testthat::expect_equal(a + b, b + a)
)
}
