% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character.R
\name{character_}
\alias{character_}
\alias{character_letters}
\alias{character_numbers}
\alias{character_alphanumeric}
\title{Character generators}
\usage{
character_(len = c(1L, 10L), any_na = FALSE, any_empty = FALSE)

character_letters(len = c(1L, 10L), any_na = FALSE, any_empty = FALSE)

character_numbers(len = c(1L, 10L), any_na = FALSE, any_empty = FALSE)

character_alphanumeric(len = c(1L, 10L), any_na = FALSE, any_empty = FALSE)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}

\item{any_na}{Whether \code{NA} values should be allowed.}

\item{any_empty}{Whether empty character values should be allowed.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
A set of generators for character vectors.
}
\examples{
character_() \%>\% show_example()
character_(len = 10L, any_na = TRUE) \%>\% show_example()
character_(len = 10L, any_empty = TRUE) \%>\% show_example()
}
