% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiers.R
\name{equal_length}
\alias{equal_length}
\title{Equal length vector generator}
\usage{
equal_length(..., len = c(1L, 10L))
}
\arguments{
\item{...}{A set of named or unnamed vector generators.}

\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
Generates equal length vectors contained in a list.
}
\examples{
equal_length(integer_(), double_()) \%>\% show_example()
equal_length(a = logical_(), b = character_(), len = 5L) \%>\% show_example()
}
