% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_filter.R
\name{mutate_filter}
\alias{mutate_filter}
\title{Mutate only a subset of dataset intact}
\usage{
mutate_filter(., sub.set, ...)
}
\arguments{
\item{.}{data object}

\item{sub.set}{subset of data to modify}

\item{...}{mutation syntax similar to dplyr::mutate}
}
\value{
data frame containing original data, but with a subset mutated
}
\description{
Extension of the dplyr::mutate function that allows the user to mutate only a specific filtered subset of a data, while leaving the other parts of the data intact
}
\examples{
#mutate a subsection filter of mtcars
dt = mtcars
names(dt)
head(dt)
mutate_filter(dt,mpg == 21.0 & cyl == 6, cyl=1000,hp=2000,vs=hp*2)


dt2 = beaver1
names(dt2)
head(dt2)
mutate_filter(dt2, day == 346 & time < 1200, activ = 12, temp = round(temp*10,1))
}
