% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_payoffs.R
\name{estimate_payoffs}
\alias{estimate_payoffs}
\title{Estimate Payoff Parameters for HIV Phenotype Interactions}
\usage{
estimate_payoffs(class_obj, predictions_df)
}
\arguments{
\item{class_obj}{An object of class \code{InteractionClassification} containing
the data on viral load differences and CD4 counts.}

\item{predictions_df}{A data frame containing predictions of viral loads,
with a column named \code{predictions}. This data frame should align with the
classifications in \code{class_obj}.}
}
\value{
A payoffs object containing the estimated payoff parameters
}
\description{
This function estimates the payoff parameters for HIV phenotype interactions
based on the provided classification object and predictions from a viral
load model. It calculates the mean differences in viral loads and CD4 counts,
as well as the average payoffs for each classification.
}
\examples{
\dontrun{
library(dplyr)
library(earth)
library(baguette)
library(rules)
library(kknn)
library(viralmodels)
# Load required data
data(vl_3)
data(cd_3)

# Create interaction object and classification
interaction_obj <- create_interactions(cd_3[,-1], vl_3[,-1])
class_obj <- InteractionClassification(interaction_obj$vlogs_diff, interaction_obj$cds_diff)

# Prepare predictions
traindata <- interaction_obj[c(2, 5)] |> as_tibble()
target <- "vlogs_diff"
predictions_df <- viralpreds(target, 2, 1, 2, 123, traindata)

# Estimate payoffs
payoffs_results <- estimate_payoffs(class_obj, predictions_df)
}
}
