% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frmtp.R
\name{frmtp}
\alias{frmtp}
\title{Format P-values}
\usage{
frmtp(x, style = getOption("qwraps2_journal", "default"),
  digits = getOption("qwraps2_frmtp_digits", 4),
  markup = getOption("qwraps2_markup", "latex"),
  case = getOption("qwraps2_frmtp_case", "upper"),
  leading0 = getOption("qwraps2_frmtp_leading0", TRUE), ...)
}
\arguments{
\item{x}{a vector of P-values to format}

\item{style}{a character string indicating a specific journal requirements
for p-value formatting.}

\item{digits}{number of digits to the right of the decimal point.}

\item{markup}{a character string indicating if the output should be latex or
markup.}

\item{case}{a character string indicating if the output should be upper case
or lower case.}

\item{leading0}{boolean, whether or not the p-value should be reported as
0.0123 (TRUE, default), or .0123 (FALSE).}

\item{...}{Not currently implemented.}
}
\value{
a character vector of the formatted p-values
}
\description{
A function for formating P-values in general and in journal
specific formats.
}
\details{
The single function call to \code{frmtp} formats P-values per journal
requirements.  As I work on papers aimed at different journals, the
formatting functions will be extended to match.

Default settings are controlled through the function arguments but should be
set via \code{options()}.

Default settings report the P-value exactly if P >
\code{getOptions("qwraps2_frmtp_digits", 4)} and reports
P < \code{10^-(getOptions("qwraps2_frmtp_digits", 2))} otherwise.  By the
leading zero is controlled via
\code{getOptions("qwraps2_frmtp_leading0", TRUE)}
and a upper or lower case P is controlled by
\code{getOptions("qwraps2_frmtp_case", "upper")}.  These options are ignored
if \code{style != "default"}.

Journals with predefined P-value formatting are noted in the
\pkg{\link{qwraps2}} documentation.
}
\examples{
ps <- c(0.2, 0.001, 0.00092, 0.047, 0.034781, 0.0000872, 0.787, 0.05, 0.043)
# LaTeX is the default markup language
cbind("raw"      = ps,
      "default"  = frmtp(ps),
      "3lower"   = frmtp(ps, digits = 3, case = "lower"),
      "PediDent" = frmtp(ps, style = "pediatric_dentistry"))

# Using markdown
cbind("raw"      = ps,
      "default"  = frmtp(ps, markup = "markdown"),
      "3lower"   = frmtp(ps, digits = 3, case = "lower", markup = "markdown"),
      "PediDent" = frmtp(ps, style = "pediatric_dentistry", markup = "markdown"))
}
\seealso{
\code{\link{frmt}}
}

