% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_ci.R
\name{mean_ci}
\alias{mean_ci}
\alias{print.qwraps2_mean_ci}
\title{Means and Confidence Intervals}
\usage{
mean_ci(x, na_rm = FALSE, transform, alpha = getOption("qwraps2_alpha",
  0.05), qdist = stats::qnorm, qdist.args = list())

\method{print}{qwraps2_mean_ci}(x, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{na_rm}{if true, omit NA values}

\item{transform}{function transform to the mean and the confidence limits.
See Details.}

\item{alpha}{defaults to \code{getOption('qwraps2_alpha', 0.05)}.  The
symmetric 100(1-alpha)\% CI will be determined.}

\item{qdist}{defaults to \code{qnorm}.  use \code{qt} for a Student t
intervals.}

\item{qdist.args}{list of arguments passed to \code{qdist}}

\item{...}{arguments passed to \code{frmtci}.}
}
\value{
a vector with the mean, lower confidence limit (LCL), and the upper
confidence limit (UCL).
}
\description{
A function for calculating and formatting means and 
confidence interval.
}
\details{
Given a numeric vector, \code{mean_ci} will return a vector with the mean,
LCL, and UCL.  Using \code{frmtci} will be helpfull for reporting the results
in print.

The \code{transform} arguement allows the use to transform the data.  A
common occurance of using \code{mean_ci(log(x), transform = exp)} will return
the geometric mean and confidence interval for x.
}
\examples{
# using the standard normal for the CI
mean_ci(mtcars$mpg)

# print it nicely
qwraps2::frmtci(mean_ci(mtcars$mpg))
qwraps2::frmtci(mean_ci(mtcars$mpg), show_level = TRUE)
qwraps2::frmtci(mean_ci(mtcars$mpg, alpha = 0.01), show_level = TRUE)

# Compare to the ci that comes form t.test
t.test(mtcars$mpg)
t.test(mtcars$mpg)$conf.int
mean_ci(mtcars$mpg, qdist = stats::qt, qdist.args = list(df = 31))

# geometric version
mean_ci(log(mtcars$mpg), transform = exp, qdist = stats::qt, qdist.args = list(df = 31))

}
\seealso{
\code{\link{frmtci}}
}

