% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prioritize.R
\name{prioritize}
\alias{prioritize}
\title{Pick rows where \code{score} is 1 and \code{level} per loan is of highest \code{priority}}
\usage{
prioritize(data, priority = NULL)
}
\arguments{
\item{data}{A data frame like the validated output of \code{\link[=match_name]{match_name()}}. See
\emph{Details} on how to validate \code{data}.}

\item{priority}{One of:
\itemize{
\item \code{NULL}: defaults to the default level priority as returned by
\code{\link[=prioritize_level]{prioritize_level()}}.
\item A character vector giving a custom priority.
\item A function to apply to the output of \code{\link[=prioritize_level]{prioritize_level()}}, e.g. \code{rev}.
\item A quosure-style lambda function, e.g. \code{~ rev(.x)}.
}}
}
\value{
A data frame with a single row per loan, where \code{score} is 1 and
priority level is highest.
}
\description{
When multiple perfect matches are found per loan (e.g. a match at
\code{direct_loantaker} level and \code{ultimate_parent} level), we must prioritize the
desired match. By default, the highest \code{priority} is the most granular match
(i.e. \code{direct_loantaker}).
}
\details{
\strong{How to validate \code{data}}

Write the output of \code{match_name()} into a .csv file with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Writting to current working directory
matched \%>\%
  readr::write_csv("matched.csv")
}\if{html}{\out{</div>}}

Compare, edit, and save the data manually:
\itemize{
\item Open \emph{matched.csv} with any spreadsheet editor (Excel, Google
Sheets, etc.).
\item Compare the columns \code{name} and \code{name_abcd} manually to determine if
the match is valid. Other information can be used in conjunction
with just the names to ensure the two entities match (sector,
internal information on the company structure, etc.)
\item Edit the data:
\itemize{
\item If you are happy with the match, set the \code{score} value to \code{1}.
\item Otherwise set or leave the \code{score} value to anything other than
\code{1}.
}
\item Save the edited file as, say, \emph{valid_matches.csv}.
}

Re-read the edited file (validated) with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Reading from current working directory
valid_matches <- readr::read_csv("valid_matches.csv")
}\if{html}{\out{</div>}}
}
\section{Handling grouped data}{

This function ignores but preserves existing groups.
}

\examples{
library(dplyr)

# styler: off
matched <- tribble(
  ~sector, ~sector_abcd,  ~score, ~id_loan,                ~level,
   "coal",      "coal",       1,     "aa",     "ultimate_parent",
   "coal",      "coal",       1,     "aa",    "direct_loantaker",
   "coal",      "coal",       1,     "bb", "intermediate_parent",
   "coal",      "coal",       1,     "bb",     "ultimate_parent",
)
# styler: on

prioritize_level(matched)

# Using default priority
prioritize(matched)

# Using the reverse of the default priority
prioritize(matched, priority = rev)

# Same
prioritize(matched, priority = ~ rev(.x))

# Using a custom priority
bad_idea <- c("intermediate_parent", "ultimate_parent", "direct_loantaker")

prioritize(matched, priority = bad_idea)
}
\seealso{
\code{\link[=match_name]{match_name()}}, \code{\link[=prioritize_level]{prioritize_level()}}.

Other main functions: 
\code{\link{match_name}()}
}
\concept{main functions}
