\name{r2lUniv.Rclasses}
\alias{r2lUniv.Rclasses}
\alias{r2lUniv.factor}
\alias{r2lUniv.logical}
\alias{r2lUniv.ordered}
\alias{r2lUniv.integer}
\alias{r2lUniv.numeric}
\alias{r2lUniv.number}

\title{Methods for \R classes}
\description{
  Methods used by \code{r2lUniv} for \code{factor}, \code{logical},
  \code{ordered}, \code{integer} and \code{numeric}.
  
  On these variables, \code{r2lUniv} chooses the
  \link[=r2lConcepts]{r2lUniv basic classes} corresponding 
  then runs the \link[=r2lConcepts]{r2lUniv basic analyses}.
}
\usage{
\method{r2lUniv}{factor}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V",...)
\method{r2lUniv}{logical}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V",...)
\method{r2lUniv}{ordered}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V",...)
\method{r2lUniv}{integer}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V", limDiscrete = 10,...)
\method{r2lUniv}{numeric}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V", limDiscrete = 10,...)
}

\arguments{
    \item{data}{\code{vector};
    to print}
  
  \item{fileOutput}{\code{character};
    name of the output file to save the LaTeX code. If
    empty, code is printed on screen.}
  
  \item{varName}{\code{character}, single;
    title of the \link[=r2lConcepts]{LaTeX summary}. For no title, use NA
    instead of "".}
  
  \item{varNumber}{\code{numeric}, single;
    number to be printed before the title. For no number, use NA
    instead of "".}
  
  \item{dirGraph}{\code{character};
    Directory used to save the graphs generated by the analyses.}
  
  \item{graphName}{\code{character}, single;
    Prefix of the graphs' names. The full names of the graphs will be
    \code{graphName} with a postfix in ("-boxplot.eps", "-barplot.eps",
    "-hist.eps") }

  \item{limDiscrete}{\code{numeric};
    Fixes the limit that distinguishes continuous variables
    from discrete ones. See \code{\link{r2lFindClass}} for details.}

  \item{...}{For S3 compatibility only}
}

\details{
  On a variable with standard \R class, \code{r2lUniv} chooses the
  \link[=r2lConcepts]{r2lUniv basic classes} corresponding to the \R class
  then runs the \link[=r2lConcepts]{r2lUniv basic analyses}.

  The \link[=r2lConcepts]{r2l basic class} of the variable is first set by the
  \code{\link{r2lFindClasses}}. 

  Then \code{r2lUniv} is called. See \code{\link{r2lUniv.r2lBasicClasses}}
  for what happens next.
}
\value{
  See \code{\link{r2lUniv.r2lBasicClasses}} for details.
}

\seealso{\code{\link[utils]{Sweave}},
  \code{\link[Hmisc]{latex}},
  \code{\link{r2lUniv}},
  \code{\link{r2lConcepts}},
  \code{\link{r2lUniv.r2lBasicClasses}},
  \code{\link{r2lUniv.data.frame}},
  \code{\link{r2lFindClass}}
}

\references{LaTeX web site \url{http://www.latex-project.org/}}

\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris
}

\section{English correction}{
  Jean-Marc Chamot \cr
  \email{jchamot@u-paris10.fr}\cr
  Laboratoire "Sport & Culture" / "Sports & Culture" Laboratory \cr
  University of Paris 10 / Nanterre
}



\examples{
 # # # # # # # # # # # # # # # # # # #
#   R to LaTeX, Univariate Analyses   #
 #             Examples              #
  #           R  classes            #
   # # # # # # # # # # # # # # # # #

########################
###### Load the data

data(Vfactor)
data(Vlogical)
data(Vordered)
data(Vinteger)
data(Vnumeric)


########################
###### Run r2lUniv

### The following code will create some files.
### We advise you to first move to directory "r2lUnivExample"
dir.create("r2lUnivExample")
setwd("r2lUnivExample")
dir.create("graph")

### Univariate analyses
r2lUniv(Vfactor,"factor.tex")
r2lUniv(Vlogical,"logical.tex",varName="RepeatingYear",graphName="L")
r2lUniv(Vordered,"ordered.tex",varNumber="3",graphName="O")
r2lUniv(Vinteger,"integer.tex",varName="Age",varNumber="4",graphName="I")
r2lUniv(Vnumeric,"numeric.tex",varName="CheatScore",varNumber="5",graphName="N",dirGraph="graph")

### Creates the main document.
r2lGenerateLatexMain(c("factor.tex","logical.tex","ordered.tex","integer.tex","numeric.tex"))

### Everything is ready, you can now run LaTeX on the file "main.tex"
setwd("..")
}

\keyword{univar}       % Simple univariate statistics
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{classes}      % Data type
\keyword{print}        % Printing
