/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Entity;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.XMLUtil;

public class ModelUtil {
    private static final Pattern FUNCTION_INVOCATION = Pattern.compile("^(.+)\\((.+)\\)$");

    private ModelUtil() {
    }

    public static MiningSchema createMiningSchema(Label label) {
        FieldName name;
        MiningSchema miningSchema = new MiningSchema();
        if (label != null && (name = label.getName()) != null) {
            MiningField miningField = ModelUtil.createMiningField(name, MiningField.UsageType.TARGET);
            miningSchema.addMiningFields(new MiningField[]{miningField});
        }
        return miningSchema;
    }

    public static MiningField createMiningField(FieldName name) {
        return ModelUtil.createMiningField(name, null);
    }

    public static MiningField createMiningField(FieldName name, MiningField.UsageType usageType) {
        MiningField miningField = new MiningField(name).setUsageType(usageType);
        return miningField;
    }

    public static Targets createRescaleTargets(Number slope, Number intercept, ContinuousLabel continuousLabel) {
        FieldName name = continuousLabel.getName();
        Target target = new Target().setField(name);
        boolean rescaled = false;
        if (slope != null && !ValueUtil.isOne(slope)) {
            target.setRescaleFactor(slope);
            rescaled = true;
        }
        if (intercept != null && !ValueUtil.isZeroLike(intercept)) {
            target.setRescaleConstant(intercept);
            rescaled = true;
        }
        if (!rescaled) {
            return null;
        }
        Targets targets = new Targets().addTargets(new Target[]{target});
        return targets;
    }

    public static Output ensureOutput(Model model) {
        Output output = model.getOutput();
        if (output == null) {
            output = new Output();
            model.setOutput(output);
        }
        return output;
    }

    public static Output createPredictedOutput(FieldName name, OpType opType, DataType dataType, Transformation ... transformations) {
        Output output = new Output();
        OutputField outputField = new OutputField(name, opType, dataType).setResultFeature(ResultFeature.PREDICTED_VALUE).setFinalResult(Boolean.valueOf(false));
        output.addOutputFields(new OutputField[]{outputField});
        for (Transformation transformation : transformations) {
            outputField = new OutputField(transformation.getName(outputField.getName()), transformation.getOpType(outputField.getOpType()), transformation.getDataType(outputField.getDataType())).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setFinalResult(Boolean.valueOf(transformation.isFinalResult())).setExpression(transformation.createExpression(new FieldRef(outputField.getName())));
            output.addOutputFields(new OutputField[]{outputField});
        }
        return output;
    }

    public static Output createProbabilityOutput(MathContext mathContext, CategoricalLabel categoricalLabel) {
        DataType dataType = DataType.DOUBLE;
        if (MathContext.FLOAT.equals((Object)mathContext)) {
            dataType = DataType.FLOAT;
        }
        return ModelUtil.createProbabilityOutput(dataType, categoricalLabel);
    }

    public static Output createProbabilityOutput(DataType dataType, CategoricalLabel categoricalLabel) {
        Output output = new Output();
        List outputFields = output.getOutputFields();
        outputFields.addAll(ModelUtil.createProbabilityFields(dataType, categoricalLabel.getValues()));
        return output;
    }

    public static OutputField createAffinityField(DataType dataType, Object value) {
        return ModelUtil.createAffinityField(FieldName.create((String)("affinity(" + value + ")")), dataType, value);
    }

    public static OutputField createAffinityField(FieldName name, DataType dataType, Object value) {
        OutputField outputField = new OutputField(name, OpType.CONTINUOUS, dataType).setResultFeature(ResultFeature.AFFINITY).setValue(value);
        return outputField;
    }

    public static List<OutputField> createAffinityFields(DataType dataType, List<? extends Entity<?>> entities) {
        return entities.stream().map(entity -> ModelUtil.createAffinityField(dataType, entity.getId())).collect(Collectors.toList());
    }

    public static OutputField createEntityIdField(FieldName name) {
        OutputField outputField = new OutputField(name, OpType.CATEGORICAL, DataType.STRING).setResultFeature(ResultFeature.ENTITY_ID);
        return outputField;
    }

    public static OutputField createPredictedField(FieldName name, OpType opType, DataType dataType) {
        OutputField outputField = new OutputField(name, opType, dataType).setResultFeature(ResultFeature.PREDICTED_VALUE);
        return outputField;
    }

    public static OutputField createProbabilityField(DataType dataType, Object value) {
        return ModelUtil.createProbabilityField(FieldName.create((String)("probability(" + value + ")")), dataType, value);
    }

    public static OutputField createProbabilityField(FieldName name, DataType dataType, Object value) {
        OutputField outputField = new OutputField(name, OpType.CONTINUOUS, dataType).setResultFeature(ResultFeature.PROBABILITY).setValue(value);
        return outputField;
    }

    public static List<OutputField> createProbabilityFields(DataType dataType, List<?> values) {
        return values.stream().map(value -> ModelUtil.createProbabilityField(dataType, value)).collect(Collectors.toList());
    }

    public static MathContext simplifyMathContext(MathContext mathContext) {
        return MathContext.DOUBLE.equals((Object)mathContext) ? null : mathContext;
    }

    public static VerificationField createVerificationField(FieldName name) {
        String tagName = name.getValue();
        Matcher matcher = FUNCTION_INVOCATION.matcher(tagName);
        if (matcher.matches()) {
            tagName = matcher.group(1) + "_" + matcher.group(2);
        }
        VerificationField verificationField = new VerificationField().setField(name).setColumn("data:" + XMLUtil.createTagName(tagName));
        return verificationField;
    }

    public static ModelVerification createModelVerification(Map<VerificationField, List<?>> data) {
        VerificationFields verificationFields = new VerificationFields().addVerificationFields((VerificationField[])Iterables.toArray(data.keySet(), VerificationField.class));
        InlineTable inlineTable = PMMLUtil.createInlineTable(VerificationField::getColumn, data);
        List rows = inlineTable.getRows();
        ModelVerification modelVerification = new ModelVerification(verificationFields, inlineTable).setRecordCount(Integer.valueOf(rows.size()));
        return modelVerification;
    }
}

