/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.model.ToStringHelper;

public class BaseNFeature
extends Feature
implements HasDerivedName {
    private int base = -1;
    private int index = -1;
    private SetMultimap<Integer, ?> values = null;

    public BaseNFeature(PMMLEncoder encoder, Field<?> field, int base, int index, SetMultimap<Integer, ?> values) {
        this(encoder, field.getName(), field.getDataType(), base, index, values);
    }

    public BaseNFeature(PMMLEncoder encoder, Feature feature, int base, int index, SetMultimap<Integer, ?> values) {
        this(encoder, feature.getName(), feature.getDataType(), base, index, values);
    }

    public BaseNFeature(PMMLEncoder encoder, FieldName name, DataType dataType, int base, int index, SetMultimap<Integer, ?> values) {
        super(encoder, name, dataType);
        this.setBase(base);
        this.setIndex(index);
        this.setValues(values);
    }

    @Override
    public FieldName getDerivedName() {
        return FieldNameUtil.create("base" + this.getBase(), this.getName(), this.getIndex());
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        FieldName name = this.getName();
        DataType dataType = this.getDataType();
        int base = this.getBase();
        SetMultimap<Integer, ?> values = this.getValues();
        Supplier<Expression> expressionSupplier = () -> {
            Collection categories;
            Map valueMap = values.asMap();
            if (base == 2 && (categories = (Collection)valueMap.get(1)) != null && categories.size() == 1) {
                Object category = Iterables.getOnlyElement((Iterable)categories);
                return new NormDiscrete(name, category);
            }
            Apply apply = null;
            Apply prevIfApply = null;
            Collection entries = valueMap.entrySet();
            entries = entries.stream().sorted((left, right) -> Integer.compare((Integer)left.getKey(), (Integer)right.getKey())).filter(entry -> (Integer)entry.getKey() > 0).collect(Collectors.toList());
            for (Map.Entry entry2 : entries) {
                Integer baseValue = (Integer)entry2.getKey();
                Collection categories2 = (Collection)entry2.getValue();
                Apply valueApply = PMMLUtil.createApply(categories2.size() == 1 ? "equal" : "isIn", new Expression[]{new FieldRef(name)});
                for (Object category : categories2) {
                    valueApply.addExpressions(new Expression[]{PMMLUtil.createConstant(category, dataType)});
                }
                Apply ifApply = PMMLUtil.createApply("if", new Expression[]{valueApply}).addExpressions(new Expression[]{PMMLUtil.createConstant(baseValue)});
                if (apply == null) {
                    apply = ifApply;
                }
                if (prevIfApply != null) {
                    prevIfApply.addExpressions(new Expression[]{ifApply});
                }
                prevIfApply = ifApply;
            }
            if (apply == null) {
                return PMMLUtil.createConstant(0);
            }
            prevIfApply.addExpressions(new Expression[]{PMMLUtil.createConstant(0)});
            return apply;
        };
        return this.toContinuousFeature(this.getDerivedName(), DataType.INTEGER, expressionSupplier);
    }

    public Set<?> getValues(Predicate<Integer> predicate) {
        SetMultimap<Integer, ?> values = this.getValues();
        Map valueMap = values.asMap();
        LinkedHashSet result = new LinkedHashSet();
        Set entries = valueMap.entrySet();
        entries.stream().sorted((left, right) -> Integer.compare((Integer)left.getKey(), (Integer)right.getKey())).filter(entry -> predicate.test((Integer)entry.getKey())).map(entry -> (Collection)entry.getValue()).forEach(result::addAll);
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.getBase());
        result = 31 * result + Objects.hash(this.getIndex());
        result = 31 * result + Objects.hash(this.getValues());
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BaseNFeature) {
            BaseNFeature that = (BaseNFeature)object;
            return super.equals(object) && Objects.equals(this.getBase(), that.getBase()) && Objects.equals(this.getIndex(), that.getIndex()) && Objects.equals(this.getValues(), that.getValues());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("base", (Object)this.getBase()).add("index", (Object)this.getIndex()).add("values", this.getValues());
    }

    public int getBase() {
        return this.base;
    }

    private void setBase(int base) {
        this.base = base;
    }

    public int getIndex() {
        return this.index;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    public SetMultimap<Integer, ?> getValues() {
        return this.values;
    }

    private void setValues(SetMultimap<Integer, ?> values) {
        this.values = Objects.requireNonNull(values);
    }
}

