% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_var2.r
\name{r2_var}
\alias{r2_var}
\title{r2_var function}
\usage{
r2_var(dat, v1, nv)
}
\arguments{
\item{dat}{N by (M+1) matrix having variables in the order of cbind(y,x)}

\item{v1}{This can be set as v1=c(1), v1=c(1,2) or possibly with more values}

\item{nv}{Sample size}
}
\value{
This function will test the null hypothesis for R2. To get the test statistics for R2(y~x[,v1]). The outputs are listed as follows.
\item{rsq}{R2}
\item{var}{Variance of R2}
\item{r2_based_p}{P-value under the null hypothesis, i.e. R2=0}
\item{upper_r2}{Upper limit of 95\% CI for R2}
\item{lower_r2}{Lower limit of 95\% CI for R2}
}
\description{
This function estimates var(R2(y~x[,v1]))
where R2 is the R squared value of the model,
where R2 is the R squared value of the model,
y is N by 1 matrix having the dependent variable, and
x is N by M matrix having M explanatory variables.
v1 indicates the ith column in the x matrix
(v1 can be multiple values between 1 - M, see Arguments below)
}
\examples{

#To get the test statistics for R2(y~x[,v1])
dat=dat1
nv=length(dat$V1)
v1=c(1)
output=r2_var(dat,v1,nv)
output

#r2redux output

#output$rsq (R2)
#0.03836254

#output$var (variance of R2) 
#0.0001436128

#output$r2_based_p (P-value under the null hypothesis, i.e. R2=0)
#1.188162e-10

#output$upper_r2 (upper limit of 95\% CI for R2)
#0.06433782

#output$lower_r2 (lower limit of 95\% CI for R2)
#0.01764252


#To get the test statistic for R2(y~x[,v1]+x[,v2]+x[,v3])

dat=dat1
nv=length(dat$V1)
v1=c(1,2,3) 
r2_var(dat,v1,nv)

#r2redux output

#output$rsq (R2)
#0.03836254

#output$var (variance of R2)
#0.0001436128

#output$r2_based_p (R2 based P-value)
#1.188162e-10

#output$upper_r2 (upper limit of 95\% CI for R2)
#0.06433782

#output$lower_r2 (lower limit of 95\% CI for R2)
#0.0176425


#When comparing two independent sets of PGSs 
#Let’s assume dat1$V1 and dat2$V2 are independent for this example
#(e.g. male PGS vs. female PGS)

nv=length(dat1$V1)
v1=c(1)
output1=r2_var(dat1,v1,nv)
nv=length(dat2$V1)
v1=c(1)
output2=r2_var(dat2,v1,nv)

#To get the difference between two independent sets of PGSs 
r2_diff_independent=abs(output1$rsq-output2$rsq)

#To get the variance of the difference between two independent sets of PGSs 
var_r2_diff_independent= output1$var+output2$var
sd_r2_diff_independent=sqrt(var_r2_diff_independent)

#To get p-value (following eq. 15 in the paper)
chi=r2_diff_independent^2/var_r2_diff_independent
p_value=pchisq(chi,1,lower.tail=FALSE)
#to get 95\% CI (following eq. 15 in the paper)
uci=r2_diff_independent+1.96*sd_r2_diff_independent
lci=r2_diff_independent-1.96*sd_r2_diff_independent
}
\keyword{R2}
\keyword{information}
\keyword{matrix}
\keyword{variance}
