% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_nrow.R
\name{rtf_nline_vector}
\alias{rtf_nline_vector}
\title{Calculate Number of Lines of a String Vector}
\usage{
rtf_nline_vector(text, strwidth, size)
}
\arguments{
\item{text}{a vector of string}

\item{strwidth}{a vector of string width in inches}

\item{size}{a vector of cell size in inches}
}
\value{
a vector of integer (number of lines)
}
\description{
Calculate number of lines that a string vector (e.g., title, subline, footnote, source) broken to given a specific cell size
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item \code{text} is a vector of string
   \item \code{strwidth} is a vector of string width in inches
   \item \code{size} is a vector of cell size in inches
   \item Return a vector of integer (number of lines)
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
r2rtf:::rtf_nline_vector(text = c('title 1', "this is a sentence for title 2"),
             strwidth = c(0.4, 2),
                 size = 0.5)
}
