% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animation.R, R/rd.R
\name{m_translate}
\alias{m_translate}
\alias{m_translate_scene}
\title{Translate current view or models by x,y screen coordinates}
\usage{
m_translate(id, x, y, animationDuration, fixedPath)

m_translate_scene(id, x, y, animationDuration, fixedPath)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{x}{Relative change \code{numeric} in view coordinates of camera}

\item{y}{Relative change \code{numeric} in view coordinates of camera}

\item{animationDuration}{an optional parameter of milliseconds \code{numeric}
that denotes the duration of a zoom animation}

\item{fixedPath}{if \code{true} animation is constrained to
requested motion, overriding updates that happen during the animation}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
\code{m_translate()} pans the camera rather than translating the model.
\code{m_translate_scene()} translates the models relative to the current
view. It does not change the center of rotation.
}
\examples{
library(r3dmol)

# Translate current view by x,y screen coordinates
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(style = c(m_style_cartoon(), m_style_stick())) \%>\%
  m_translate(
    x = 200,
    y = 50,
    animationDuration = 1000
  ) \%>\%
  m_rotate(
    angle = 90,
    axis = "z",
    animationDuration = 1000
  ) \%>\%
  m_zoom_to()

# Translate current models by x,y screen coordinates
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(style = c(m_style_cartoon(), m_style_stick())) \%>\%
  m_translate_scene(
    x = 200,
    y = 50,
    animationDuration = 1000
  ) \%>\%
  m_rotate(
    angle = 90,
    axis = "z",
    animationDuration = 1000
  ) \%>\%
  m_zoom_to()
}
