% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animation.R
\name{m_zoom}
\alias{m_zoom}
\title{Zoom current view by a constant factor}
\usage{
m_zoom(id, factor = 2, animationDuration, fixedPath)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{factor}{Magnification \code{numeric} factor. Values greater than
\code{1} will
zoom in, less than one will zoom out. Default \code{2}.}

\item{animationDuration}{an optional parameter of milliseconds \code{numeric}
that denotes the duration of a zoom animation}

\item{fixedPath}{if \code{true} animation is constrained to
requested motion, overriding updates that happen during the animation}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Zoom current view by a constant factor
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_zoom_to() \%>\%
  m_zoom(factor = 2, animationDuration = 1000)
}
