% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amBullet.R
\name{amBullet}
\alias{amBullet}
\title{Plotting bullet chart using rAmCharts}
\usage{
amBullet(
  value,
  min = 0,
  max = 100,
  val_color = "#000000",
  limit = 85,
  limit_color = "#000000",
  steps = TRUE,
  label = "",
  horiz = TRUE,
  rates,
  ...
)
}
\arguments{
\item{value}{\code{numeric}, value to display.}

\item{min}{\code{numeric}, minimum value allowed.}

\item{max}{\code{numeric}, maximum value allowed.}

\item{val_color}{\code{character}, color of the bar value, in hexadecimal.}

\item{limit}{\code{numeric}, target value.}

\item{limit_color}{\code{character}, color of the target line.}

\item{steps}{\code{logical}, default set to TRUE.}

\item{label}{\code{character}, label of the bullet.}

\item{horiz}{\code{logical}, TRUE (default) for an horizontal bullet chart, FALSE for a vertical one.}

\item{rates}{\code{data.frame} with 4 columns: name (character), min (numeric), max (numeric), 
and color (character, color in hexadecimal).}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
amBullet computes a bullet chart of the given value.
}
\examples{
amBullet(value = 65)

\donttest{
# Other examples available which can be time consuming depending on your configuration.

# Remove steps for background
amBullet(value = 65, steps = FALSE)

# Tune the colors with name or HTML code
amBullet(value = 65, val_color = "purple", limit_color = "#3c8dbc")

# Change the orientation
amBullet(value = 65, steps = FALSE, horiz = FALSE)

# Add text
amBullet(value = 65, label = "Evaluation")

# Change min and max values
amBullet(value = 65, min = 20, max = 90)
}


}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
