\name{cmaCalcFitness}
\alias{cmaCalcFitness}
\title{Calculate the fitness of a population.}
\usage{
  cmaCalcFitness(cma, popR, fitFunc)
}
\arguments{
  \item{cma}{CMA-ES Java object, already initialized with
  \code{\link{cmaInit}}}

  \item{popR}{a (\code{dimension x popSize}) matrix from
  \code{\link{cmaSamplePopulation}}}

  \item{fitFunc}{a function to be minimized. Signature:
  accepts a vector \code{x}, returns a \code{double}.}
}
\value{
  \code{fitness}, a vector of length
  \code{\link{cmaGetPopulationSize}(cma)} with the fitness
  of each individuum
}
\description{
  The population is usually obtained by
  \code{\link{cmaSamplePopulation}}.
}
\examples{
cma <- cmaNew();
   cmaInit(cma,dimension=2,initialX=1.5);
   popR <- cmaSamplePopulation(cma);
   fitFunc <- function(x) {sum(x*x)};
   fitness <- cmaCalcFitness(cma,popR,fitFunc);
   cmaUpdateDistribution(cma,fitness);
}
\author{
  Wolfgang Konen, FHK, 2013
}
\seealso{
  \code{\link{cmaSamplePopulation}},
  \code{\link{cmaUpdateDistribution}}, \code{\link{cmaNew}}
}

