% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.als.R
\name{depthVsSample}
\alias{depthVsSample}
\title{Simulate median allele ratios for varying no. of samples and depth coverage}
\usage{
depthVsSample(
  cov.len = 400,
  sam.len = 1000,
  incr = c(1, 1),
  plot = TRUE,
  plot.cols = c("red", "cyan")
)
}
\arguments{
\item{cov.len}{max value of depth of coverage to be simulated}

\item{sam.len}{maximum no. of samples to be simulated}

\item{incr}{a vector of two integers indicating increment size for both
depth and no. samples ranges}

\item{plot}{logical. Whether to plot the output (a plot of no. samples
vs median depth of coverage colored by median allele ratios)}

\item{plot.cols}{character. Two colors to add to the gradient}
}
\value{
A matrix of median allele ratios where rows are the number of
samples and columns are depth of coverage values
}
\description{
This function will simulate the expected median allele ratios under HWE
for given ranges of no. of samples and depth coverage values.
This is useful if you need to find the cutoff values of allele ratios for
different no. of samples and depth of coverage values in your data set.
}
\examples{
\dontrun{depthVsSample(cov.len=50,sam.len=100)}

}
\author{
Pascal Milesi, Piyal Karunarathne
}
