% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{dupGet}
\alias{dupGet}
\title{Detect duplicates from SNPs}
\usage{
dupGet(
  data,
  test = c("z.het", "z.05", "z.all", "chi.het", "chi.05", "chi.all"),
  intersection = FALSE,
  method = c("fisher", "chi.sq"),
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{data frame of the output of \code{allele.info}}

\item{test}{character. type of test to be used for significance. See details}

\item{intersection}{logical, whether to use the intersection of the methods
specified in \code{test} (if more than one)}

\item{method}{character. method for testing excess of heterozygotes.
Fisher exact test (\code{fisher}) or Chi-square test (\code{chi.sq})}

\item{plot}{logical. whether to plot the detected singlets and duplicates
on allele ratio vs. proportion of heterozygotes plot.}

\item{verbose}{logical. show progress}

\item{\dots}{additional parameters passed on to \code{plot}}
}
\value{
Returns a data frame of snps/alleles with their duplication status
}
\description{
Detect duplicated snps using excess of heterozygotes
(alleles that do not follow HWE) and snp deviates
(alleles that do not follow a normal or chi-square distribution).
See details.
}
\details{
Duplicates are detected with both excess of heterozygosity
according to HWE and deviant SNPs where deviants are detected using the
following methods:
\enumerate{
\item Z-score test \eqn{Z = \frac{\frac{N}{2} -  N_{A}}{\sigma _{x}}}
\item chi-square test (see references for more details on the method)
}

Users can pick among Z-score for heterozygotes (\code{z.het, chi.het}),
all allele combinations (\code{z.all, chi.all}) and the assumption of no
probe bias p=0.5 (\code{z.05, chi.05})
}
\examples{
\dontrun{data(alleleINF)
DD<-dupGet(alleleINF)}

}
\author{
Piyal Karunarathne
}
