% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_process.R
\name{gt.format}
\alias{gt.format}
\title{Format genotype for BayEnv and BayPass}
\usage{
gt.format(gt, info, format = c("benv", "bpass"), snp.subset = NULL)
}
\arguments{
\item{gt}{multi-vector. an imported data.frame of genotypes or genotype
data frame generated by \code{hetTgen} or path to GT.FORMAT
file generated from VCFTools}

\item{info}{a data frame containing sample and population information.
It must have \dQuote{sample} and \dQuote{population} columns}

\item{format}{character. output format i.e., for BayPass or BayEnv}

\item{snp.subset}{numerical. number of randomly selected subsets of SNPs.
\code{default = NULL}
subset}
}
\value{
Returns a list with formatted genotype data: \code{$bayenv} - snps
in horizontal format - for BayEnv (two lines per snp); \code{$baypass} - vertical format - for BayPass
(two column per snp); \code{$sub.bp} - subsets snps for BayPass \code{$sub.be} - subsets of snps for BayEnv
}
\description{
This function generates necessary genotype count formats for BayEnv and
BayPass with a subset of SNPs
}
\examples{
\dontrun{vcf.file.path <- paste0(path.package("rCNV"), "/example.raw.vcf.gz")
vcf <- readVCF(vcf.file.path=vcf.file.path)
het.table<-hetTgen(vcf,"GT")
info<-unique(substr(colnames(het.table)[-c(1:3)],1,8))
GT<-gt.format(het.table,info)}

}
\author{
Piyal Karunarathne
}
