% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview_interface.R
\name{make_block}
\alias{make_block}
\title{Make a lagged block for multiview}
\usage{
make_block(block, max_lag = 3, t = NULL, lib = NULL, tau = 1)
}
\arguments{
\item{block}{a data.frame or matrix where each column is a time series}

\item{max_lag}{the total number of lags to include for each variable}

\item{t}{the time index for the block}

\item{lib}{a 2-column matrix (or 2-element vector) where each row specifes the 
first and last *rows* of the time series to use for attractor reconstruction}

\item{tau}{the lag to use for time delay embedding}
}
\value{
A data.frame with the lagged columns and a time column
}
\description{
\code{make_block} generates a lagged block with the appropriate max_lag and 
tau, while respecting lib (by inserting NANs, when trying to lag past lib 
regions)
}
