% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_events.R
\name{last_events}
\alias{last_events}
\title{Selects the earliest event grouped by patient}
\usage{
last_events(db = NULL, tab, columns = "eventdate", where = NULL,
  sql_only = FALSE, group_column = "patid", date_column = "eventdate")
}
\arguments{
\item{db}{A database connection object}

\item{tab}{the database table to extract from}

\item{columns}{The other columns to be extracted}

\item{where}{sting representation of the selection criteria}

\item{sql_only}{logical should the function just return a string of the SQL query?}

\item{group_column}{column to group by.  Default is patid}

\item{date_column}{the column to sort by.  default is eventdate}
}
\value{
a dataframe or a string representing an sql query
}
\description{
This function runs a select_events() query and then groups by patient id and picks only the 
latest event for each patient
}
\examples{
\dontrun{
b2 <- last_events(db, tab = "Clinical", other_columns = c("eventdate", "medcode"), 
where = "medcode \%in\% .(a$medcode)")
}
}

