% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel2BPAIProfile.R
\name{clipLevel2BPAIProfile}
\alias{clipLevel2BPAIProfile}
\title{Clip GEDI Plant Area Index profile by Coordinates}
\usage{
clipLevel2BPAIProfile(level2BPAIProfile, xmin, xmax, ymin, ymax)
}
\arguments{
\item{level2BPAIProfile}{A GEDI Level2B object (output of \code{\link[rGEDI:getLevel2BPAIProfile]{getLevel2BPAIProfile}} function).
An S4 object of class "gedi.level2b".}

\item{xmin}{Numeric. West longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{xmax}{Numeric. East longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymin}{Numeric. South latitude (y) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymax}{Numeric. North latitude (y) coordinate of the bounding rectangle, in decimal degrees.}
}
\value{
Returns an S4 object of class \code{\link[data.table:data.table]{data.table-class}}
containing the Plant Area Index profile data.
}
\description{
This function clips GEDI level2B derived
Plant Area Index profile a within given bounding coordinates
}
\examples{
# Specifying the path to GEDI level2B data (zip file)
level2B_fp_zip <- system.file("extdata",
                  "GEDI02_B_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Bpath <- unzip(level2B_fp_zip,exdir = dirname(level2B_fp_zip))

# Reading GEDI level2B data (h5 file)
level2b<-readLevel2B(level2Bpath=level2Bpath)

# Extracting GEDI Plant Area Index profile
level2BPAIProfile<-getLevel2BPAIProfile(level2b)

# Bounding rectangle coordinates
xmin = -44.15036
xmax = -44.10066
ymin = -13.75831
ymax = -13.71244

# Clipping GEDI Plant Area Index profile by extent boundary box
level2b_clip <- clipLevel2BPAIProfile(level2BPAIProfile,xmin, xmax, ymin, ymax)

close(level2b)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi02_bv001/
}
