% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estKIN.R
\name{estKIN}
\alias{estKIN}
\title{Estimate Kernel Isotope Niche}
\usage{
estKIN(
  data,
  x,
  y,
  h = "ref",
  hval = NULL,
  group,
  levels = c(50, 75, 95),
  scaler = 10,
  smallSamp = FALSE
)
}
\arguments{
\item{data}{data.frame object containing columns of isotopic values and grouping variables}

\item{x}{character giving the column name of the x coordinates}

\item{y}{character giving the column name of the y coordinates}

\item{h}{character describing the bandwidth estimator method. Default = "ref". See Details for more information.}

\item{hval}{numeric vector of length 2 describing the bandwidth in x and y directions. Default = NULL}

\item{group}{character giving the column name of the grouping variable (i.e. species)}

\item{levels}{Numeric vector of desired percent levels (e.g. c(10, 50, 90). Should not be less than 1 or greater than 99)}

\item{scaler}{numeric value to expand the min/max x and y values. This assists with error given smaller sample sizes. Default value = 10}

\item{smallSamp}{logical value indicating whether to override minimum number of samples. Currently 10 samples are required.}
}
\value{
A class rKIN object containing a list of sf data frames, each list item representing the grouping variable.
}
\description{
Calculates the 2D kernel for isotopic values at multiple confidence levels. Returns a list of
sf data frames, each list item representing the grouping variable (i.e. species).
}
\details{
Details
For the h argument there are 8 different bandwidth estimation options ("hns", "hpi", "hscv", "hlscv", "hbcv", "hnm", "hucv", "ref").
"ref" = The default MASS::kde2d bandwidth method. The remaining options are obtained from the 'ks' package with the default
method being "hpi". For all ks package methods, the defualt values are accepted and only the x and y values are passed to the
bivariate bandwidth estimating functions. For all bandwidth estimation methods, reducing the data to an individual group will provide the same bandwidths as used during rKIN estimation.

* hpi  - Default Plug-in bandwidth selector using ks::Hpi function. Values can be obtained using bw_hpi().
* hns  - Normal scale bandwidth using ks::Hns function.Values can be obtained using bw_hns().
* hscv - Smoothed cross-validation bandwidth selector. Values can be obtained using bw_hscv().
* hlscv - Least-squares cross-validation bandwidth matrix selector for multivariate data. Values can be obtained using bw_hlscv().
* hbcv - Biased cross-validation bandwitdh matrix selector for bivariate data. Values can be obtained using bw_hbcv().
* hnm - Normal mixture bandwidth. Values can be obtained using bw_hnm().
* hucv - Least-squares cross-validation bandwidth matrix selector for multivariate data. Values can be obtained using bw_hucv().
* ref - Uses MASS::bandwidth.nrd for both x and y separately, dividing values by 4 to match the scale of ks methods. Values can be obtained using bw_ref(). See MASS:kde2d() for details (i.e. the function divides the values by 4).
}
\examples{
library(rKIN)
data("rodents")
#estimate niche overlap between 2 species using kernel UD
test.kin<- estKIN(data=rodents, x="Ave_C", y="Ave_N", group="Species",
                 levels=c(50, 75, 95), scaler=2)
#determine polygon overlap for all polygons
plotKIN(test.kin, scaler=2, title="Kernel Estimates", xlab="Ave_C", ylab="Ave_N")
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}
