% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get_values}
\alias{get_values}
\title{Get data from Kolada}
\usage{
get_values(
  kpi = NULL,
  municipality = NULL,
  period = NULL,
  ou = NULL,
  unit_type = "municipality",
  max_results = NULL,
  simplify = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{kpi}{What kpis should be fetched? Can be a single name or a vector of
names.}

\item{municipality}{For which municipalities should data be fetched? Can be a
single name or a vector of names.}

\item{period}{For what years should data be fetched? Can be one or more
four-digit integers or character strings.}

\item{ou}{(Optional) for what Operating Units should data be fetched? Only
available for certain KPIs.}

\item{unit_type}{One of \code{"municipality"} or \code{"ou"}. Whether to
fetch data for Municipalities or Organizational Units.}

\item{max_results}{(Optional) Specify the maximum number of results
returned by the query.}

\item{simplify}{Whether to make results more human readable.}

\item{verbose}{Whether to print the call to the Kolada API as a message to
the R console.}
}
\value{
A tibble containing Kolada values and metadata.
}
\description{
Download a table of data from Kolada. Data is selected based on three
metadata dimensions: KPI (ID), municipality (ID) and period (years). You must
supply arguments for at least two of these three dimensions. If a dimension
is omitted, all available data for that dimension will be downloaded.
}
\examples{
# Download data for KPIs for Gross Regional Product ("BRP" in Swedish)
# for three municipalities
brp_kpi <- get_kpi(
  id = c("N03068", "N03069", "N03070", "N03700", "N03701")
) \%>\%
 kpi_search("BRP") \%>\%
 kpi_extract_ids()

munic_sample <- get_municipality() \%>\%
  municipality_name_to_id(c("Stockholm", "Arboga", "Lund"))

grp_data <- get_values(
  kpi = brp_kpi,
  municipality = munic_sample
)

# If you already know the ID numbers you are looking for,
# you can use these directly as argments.
grp_data <- get_values(
  kpi = c("N03700", "N03701"),
  municipality = c("0180", "1480", "1280")
)

# To download OU data instead of Municipality data, set the parameter
# "unit_type" to "ou".
ou_data <- get_values(
 kpi = "N15033",
 ou = "V15E144001101",
 unit_type = "ou"
)

}
