% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmp.R
\name{glmp}
\alias{glmp}
\title{Define the GLMP}
\usage{
glmp(pms, method)
}
\arguments{
\item{pms}{is the list of \code{\link{pm}} objects included in the \code{glmp}.}

\item{method}{is the function with the glmp computational model. The method must have two arguments: the list of
\code{\link{pm}} objects defined in the \code{glmp} and the input \code{data}:

\code{my_glmp_method <- function(pm,input)}}
}
\value{
The generated \code{glmp = list(pm, method)}
}
\description{
Granular Linguistic Model of Phenomena (GLMP) is a network of \code{\link{cp}} and \code{\link{pm}} objects.
that allows the designer to model computationally her/his own perceptions. The input data are introduced
into the model through 1PMs which interpret the input data and create CPs. Then, 2PMs take several CPs
as input and generate 2CPs. Of course, following the same scheme, is possible to add additional upper levels.

The \code{glmp} constructor receive as arguments the list of pms and the method with the computational model.
}
\examples{
\dontrun{glmp_method <- function(pm,input){

  pm$pm_depth   <- pm_infer(pm$pm_depth, input[1])
  pm$pm_height  <- pm_infer(pm$pm_height,input[2])
  pm$pm_width   <- pm_infer(pm$pm_width, input[3])

  pm$pm_frame  <- pm_infer(pm$pm_frame, list( pm$pm_depth$y,
                                           pm$pm_height$y,
                                           pm$pm_width$y)
  )
  pm
}

my_glmp <- glmp(list(pm_depth  = pm_depth,
                     pm_height = pm_height,
                     pm_width  = pm_width,
                     pm_frame  = pm_frame),
                glmp_method)
                }
}

