% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtr.plotting.R
\name{wtr.heat.map}
\alias{wtr.heat.map}
\title{Plots a heat-map of water temperature.}
\usage{
wtr.heat.map(wtr, ...)
}
\arguments{
\item{wtr}{Data frame of water temperature loaded with
\code{\link{load.ts}}.}

\item{...}{Additional parameters supplied to \code{\link{filled.contour}}
to modify defaults. Common examples include \code{zlim} and
\code{plot.title}.}
}
\description{
This creates a simple, default heatmap of water temperature.
}
\examples{

	#Get the path for the package example file included
	wtr.path <- system.file('extdata', 'Sparkling.daily.wtr', package="rLakeAnalyzer")
	
	#Load data for example lake, Sparkilng Lake, Wisconsin.
	sp.wtr = load.ts(wtr.path)
	
	#Plot default figure
	wtr.heat.map(sp.wtr)

	#Change defaults supplied to filled.contour
	wtr.heat.map(sp.wtr, zlim=c(0,15), plot.title="Sparkling Water Temp (C)")
}
\seealso{
\code{\link{load.ts}}
}
\keyword{hplot}
