% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genStack.R
\name{genStack}
\alias{genStack}
\title{Create Raster Stack}
\usage{
genStack(
  DEM,
  by = 1,
  stop = NULL,
  save = TRUE,
  file_name = NULL,
  file_type = "COG"
)
}
\arguments{
\item{DEM}{raster object}

\item{by}{numeric increment per unit depth by which layers are split. Default = 1}

\item{stop}{optional numeric value specifying depth at which to stop stacking rasters, default = NULL}

\item{save}{logical, save raster stack (TRUE) or not (FALSE), default = TRUE}

\item{file_name}{character string used to name saved raster stack}

\item{file_type}{character string defining file type to save, default = "COG"}
}
\value{
a raster stack of specified depth increments for a given waterbody. Raster stack is either stored as an object (save = FALSE) or written to a file in the directory (save = TRUE).
}
\description{
Create a raster stack from a single raster, option to save as file.
}
\examples{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
#run function
genStack(DEM, by = 1, save = FALSE)
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
