% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Data.r
\name{MVP.Data}
\alias{MVP.Data}
\title{MVP.Data: To prepare data for MVP package
Author: Xiaolei Liu, Lilin Yin and Haohao Zhang
Build date: Aug 30, 2016
Last update: Sep 12, 2018}
\usage{
MVP.Data(fileMVP = NULL, fileVCF = NULL, fileHMP = NULL,
  fileBed = NULL, fileNum = NULL, fileMap = NULL, filePhe = NULL,
  fileInd = NULL, fileKin = NULL, filePC = NULL, out = "mvp",
  sep.num = "\\t", auto_transpose = TRUE, sep.map = "\\t",
  sep.phe = "\\t", sep.kin = "\\t", sep.pc = "\\t",
  type.geno = "char", pheno_cols = NULL, SNP.impute = "Major",
  maxLine = 10000, priority = "speed", pcs.keep = 5,
  verbose = TRUE, ncpus = NULL, ...)
}
\arguments{
\item{fileMVP}{Genotype in MVP format}

\item{fileVCF}{Genotype in VCF format}

\item{fileHMP}{Genotype in hapmap format}

\item{fileBed}{Genotype in PLINK binary format}

\item{fileNum}{Genotype in numeric format; pure 0, 1, 2 matrix; m * n, m is marker size, n is sample size}

\item{fileMap}{SNP map information, there are three columns, including SNP_ID, Chromosome, and Position}

\item{filePhe}{Phenotype, the first column is taxa name, the subsequent columns are traits}

\item{fileInd}{Individual name file}

\item{fileKin}{Kinship that represents relationship among individuals, n * n matrix, n is sample size}

\item{filePC}{Principal components, n*npc, n is sample size, npc is number of top columns of principal components}

\item{out}{prefix of output file name}

\item{sep.num}{seperator for numeric file.}

\item{auto_transpose}{Whether to automatically transpose numeric genotypes,
the default is True, which will identify the most one of the rows or 
columns as a marker, If set to False, the row represents the marker and
the column represents the individual.}

\item{sep.map}{seperator for map file.}

\item{sep.phe}{seperator for phenotype file.}

\item{sep.kin}{seperator for Kinship file.}

\item{sep.pc}{seperator for PC file.}

\item{type.geno}{type parameter in bigmemory, genotype data. The default is char, it is highly recommended *NOT* to modify this parameter.}

\item{pheno_cols}{Extract which columns of the phenotype file (including individual IDs)}

\item{SNP.impute}{"Left", "Middle", "Right", or NULL for skip impute.}

\item{maxLine}{number of SNPs, only used for saving memory when calculate kinship matrix}

\item{priority}{"speed" or "memory"}

\item{pcs.keep}{how many PCs to keep}

\item{verbose}{whether to print detail.}

\item{ncpus}{The number of threads used, if NULL, (logical core number - 1) is automatically used}

\item{...}{Compatible with DEPRECATED parameters.}
}
\value{
NULL
Output files:
genotype.desc, genotype.bin: genotype file in bigmemory format
phenotype.phe: ordered phenotype file, same taxa order with genotype file
map.map: SNP information
k.desc, k.bin: Kinship matrix in bigmemory format
pc.desc, pc.bin: PC matrix in bigmemory format
Requirement: fileHMP, fileBed, and fileNum can not input at the same time
}
\description{
MVP.Data: To prepare data for MVP package
Author: Xiaolei Liu, Lilin Yin and Haohao Zhang
Build date: Aug 30, 2016
Last update: Sep 12, 2018
}
\examples{
bfilePath <- file.path(system.file("extdata", "02_bfile", package = "rMVP"), "mvp")
opts <- options(rMVP.OutputLog2File = FALSE)

MVP.Data(fileBed=bfilePath, out=tempfile("outfile"), ncpus=1)

options(opts)
}
