% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Data.r
\name{MVP.Data.impute}
\alias{MVP.Data.impute}
\title{MVP.Data.impute: To impute the missing genotype
Author: Haohao Zhang
Build date: Sep 12, 2018}
\usage{
MVP.Data.impute(
  mvp_prefix,
  out = NULL,
  mrk_bycol = TRUE,
  method = "Major",
  ncpus = NULL,
  verbose = TRUE
)
}
\arguments{
\item{mvp_prefix}{the prefix of mvp file}

\item{out}{the prefix of output file}

\item{mrk_bycol}{whether the markers are stored by columns in genotype (i.e. genotype is a n by m matrix)}

\item{method}{'Major', 'Minor', "Middle"}

\item{ncpus}{number of threads for imputing}

\item{verbose}{whether to print the reminder}
}
\value{
NULL
Output files:
imputed genotype file
}
\description{
MVP.Data.impute: To impute the missing genotype
Author: Haohao Zhang
Build date: Sep 12, 2018
}
\examples{
mvpPath <- file.path(system.file("extdata", "05_mvp", package = "rMVP"), "mvp")

MVP.Data.impute(mvpPath, tempfile("outfile"), ncpus=1)

}
