% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.EMMA.Vg.Ve.r
\name{MVP.EMMA.Vg.Ve}
\alias{MVP.EMMA.Vg.Ve}
\title{Estimate variance components using EMMA}
\usage{
MVP.EMMA.Vg.Ve(y, X, K, ngrids = 100, llim = -10, ulim = 10, esp = 1e-10)
}
\arguments{
\item{y}{phenotype, n * 2}

\item{X}{covariate matrix, the first column is 1s}

\item{K}{Kinship matrix}

\item{ngrids}{parameters for estimating vg and ve}

\item{llim}{parameters for estimating vg and ve}

\item{ulim}{parameters for estimating vg and ve}

\item{esp}{parameters for estimating vg and ve}
}
\value{
Output: REML - maximum log likelihood
Output: delta - exp(root)
Output: ve - residual variance
Output: vg - genetic variance
}
\description{
Build date: August 30, 2016
Last update: January 27, 2017
}
\examples{
\donttest{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))

K <- MVP.K.VanRaden(genotype, cpu=1)
vc <- MVP.EMMA.Vg.Ve(y=phenotype[,2], X=matrix(1, nrow(phenotype)), K=K)
print(vc)
}

}
\author{
EMMA (Kang et. al. Genetics, 2008), Modified only for speed up by Xiaolei Liu and Lilin Yin
}
