% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nei_simu.R
\name{nei_simu}
\alias{nei_simu}
\title{Simulating phenotypes with self and neighbor effects}
\usage{
nei_simu(
  geno,
  smap,
  scale,
  alpha = Inf,
  grouping = grouping,
  kernel = "exp",
  n_causal,
  pveB,
  pve,
  b_ratio = c(1, 1)
)
}
\arguments{
\item{geno}{An individual x marker matrix. Bialleles (\emph{i.e.}, A or a) must be converted into -1 or 1 digit.}

\item{smap}{A matrix showing a spatial map for individuals. The first and second column include spatial points along a x-axis and y-axis, respectively.}

\item{scale}{A numeric scalar indicating the maximum spatial distance between a focal individual and neighbors to define neighbor effects.}

\item{alpha}{Distance decay coefficient \eqn{\alpha} in a dispersal kernel. Default is set at Inf, meaning no distance decay.}

\item{grouping}{A integer vector assigning each individual to a group. This argument can be useful when a "smap" contains different experimental replicates. Default setting means that all individuals are belong to a single group.}

\item{kernel}{An option to select a negative exponential kernel \code{"exp"} or Gaussian kernel \code{"gaussian"}.}

\item{n_causal}{No. of causal markers in a simulated phenotype}

\item{pveB}{Proportion of phenotypic variation explained by fixed effects.}

\item{pve}{Proportion of phenotypic variation explained by fixed and random effects.}

\item{b_ratio}{A vector composed of two numeric scalars that control the ratio of contributions of self or neighbor effects to a phenotype. The first and second element are for self and neighbor effects, respectively.}
}
\value{
A vector of simulated phenotype values for all individuals
}
\description{
A function to simulate phenotypes caused by self and neighbor effects, with the proportion of phenotypic variation explained (PVE) by fixed and random effects controlled.
}
\examples{
set.seed(1)
g <- matrix(sample(c(-1,1),100*1000,replace = TRUE),100,1000)
gmap <- cbind(c(rep(1,nrow(g)/2),rep(2,nrow(g)/2)),c(1:ncol(g)))
x <- runif(nrow(g),1,100)
y <- runif(nrow(g),1,100)
smap <- cbind(x,y)
grouping <- c(rep(1,nrow(g)/2), rep(2,nrow(g)/2))
pheno <- nei_simu(geno=g,smap=smap,scale=44,grouping=grouping,n_causal=50,pveB=0.4,pve=0.8)

fake_nei <- list()
fake_nei[[1]] <- g
fake_nei[[2]] <- gmap
fake_nei[[3]] <- smap
fake_nei[[4]] <- data.frame(pheno,grouping)
names(fake_nei) <- c("geno","gmap","smap","pheno")
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
