% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/it.R
\name{it.interpolate}
\alias{it.interpolate}
\title{it.interpolate}
\usage{
it.interpolate(it, t)
}
\arguments{
\item{it}{IntensityTier object}

\item{t}{vector of time instances of interest}
}
\value{
IntensityTier object
}
\description{
Interpolates IntensityTier contour in given time instances.
}
\details{
a) If \code{t < min(it$t}) (or \code{t > max(it$t)}), returns the first (or the last) value of \code{it$i}.
 b) If \code{t} is existing point in \code{it$t}, returns the respective \code{it$f}.
 c) If \code{t} is between two existing points, returns linear interpolation of these two points.
}
\examples{
it <- it.sample()
it2 <- it.interpolate(it, seq(it$t[1], it$t[length(it$t)], by = 0.001))
\dontrun{
it.plot(it)
it.plot(it2)
}
}
\seealso{
\code{\link{it.getPointIndexNearestTime}}, \code{\link{it.read}}, \code{\link{it.write}}, \code{\link{it.plot}}, \code{\link{it.cut}}, \code{\link{it.cut0}}, \code{\link{it.legendre}}
}
