% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt.R
\name{pt.write}
\alias{pt.write}
\title{pt.write}
\usage{
pt.write(pt, fileNamePitchTier, format = "spreadsheet")
}
\arguments{
\item{pt}{PitchTier object}

\item{fileNamePitchTier}{file name to be created}

\item{format}{Output file format (\code{"short"} (short text format), \code{"text"} (a.k.a. full text format), \code{"spreadsheet"} (default), \code{"headerless"} (not recommended, it does not contain \code{tmin} and \code{tmax} info))}
}
\description{
Saves PitchTier to a file (in UTF-8 encoding).
\code{pt} is a list with \code{$t} and \code{$f} vectors (of the same length) at least.
If there are no \code{$tmin} and \code{$tmax} values, there are
set as min and max of \code{$t} vector.
}
\examples{
\dontrun{
pt <- pt.sample()
pt <- pt.Hz2ST(pt)    #  conversion of Hz to Semitones, reference 0 ST = 100 Hz.
pt.plot(pt)
pt.write(pt, "demo/H_st.PitchTier")
}
}
\seealso{
\code{\link{pt.read}}, \code{\link{tg.write}}, \code{\link{pt.Hz2ST}}, \code{\link{pt.interpolate}}
}
