% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_calc.R
\name{haversine}
\alias{haversine}
\title{Calculate Haversine Distance Between Two Points on Earth}
\usage{
haversine(lon1, lat1, lon2, lat2, R = 6371)
}
\arguments{
\item{lon1}{Longitude of the first point in decimal degrees.}

\item{lat1}{Latitude of the first point in decimal degrees.}

\item{lon2}{Longitude of the second point in decimal degrees.}

\item{lat2}{Latitude of the second point in decimal degrees.}

\item{R}{The radius of the Earth in kilometers.}
}
\value{
The distance between the two points in kilometers.
}
\description{
This function calculates the great-circle distance between two points on the Earth's surface,
given their longitude and latitude in decimal degrees.
It uses the Haversine formula, which accounts for the Earth's curvature.
}
\examples{
haversine(-73.9851, 40.7580, -0.1278, 51.5074)
# Distance between NY City and London.

}
