% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.operations.R
\name{operator.operations}
\alias{operator.operations}
\alias{Pr.mult}
\alias{Pr.solve}
\alias{Pl.mult}
\alias{Pl.solve}
\alias{Q.mult}
\alias{Q.solve}
\alias{Qsqrt.mult}
\alias{Qsqrt.solve}
\alias{Sigma.mult}
\alias{Sigma.solve}
\title{Operations with the Pr and Pl operators}
\usage{
Pr.mult(obj, v, transpose = FALSE)

Pr.solve(obj, v, transpose = FALSE)

Pl.mult(obj, v, transpose = FALSE)

Pl.solve(obj, v, transpose = FALSE)

Q.mult(obj, v)

Q.solve(obj, v)

Qsqrt.mult(obj, v, transpose = FALSE)

Qsqrt.solve(obj, v, transpose = FALSE)

Sigma.mult(obj, v)

Sigma.solve(obj, v)
}
\arguments{
\item{obj}{rSPDE object}

\item{v}{vector to apply the operation to}

\item{transpose}{set to TRUE if the operation should be performed with the transposed object}
}
\value{
A vector with the values of the operation
}
\description{
Functions for multiplying and solving with the \eqn{P_r} and \eqn{P_l} operators as well as
the latent precision matrix \eqn{Q = P_l C^{-1}P_l} and covariance matrix
\eqn{\Sigma = P_r Q^{-1} P_r^T}.
These operations are done without first assembling \eqn{P_r}, \eqn{P_l} in order to avoid
numerical problems caused by ill-conditioned matrices.
}
\details{
\code{Pl.mult}, \code{Pr.mult}, and \code{Q.mult} multiplies the vector with the respective object.
Changing \code{mult} to \code{solve} in the function names multiplies the vector with the inverse of the
object. \code{Qsqrt.mult} and \code{Qsqrt.solve} performs the operations with the square-root type object
\eqn{Q_r = C^{-1/2}P_l} defined so that \eqn{Q = Q_r^T Q_r}.
}
