# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

calculateCrossValidationAdapter <- function(data_matrix, method, number_of_folds, precision, output_to_file) {
    .Call(`_rSRD_calculateCrossValidationAdapter`, data_matrix, method, number_of_folds, precision, output_to_file)
}

#' @title utilsRankingMatrix
#' @name utilsRankingMatrix
#' @aliases utilsRankingMatrix
#' @author Balázs R. Sziklai \email{sziklai.balazs@@krtk.hu}, Linus Olsson \email{linusmeol@@gmail.com}
#' @description R interface to perform the rank transformation on the columns of the input data frame. 
#' Ties are resolved by fractional ranking.
#' @param data_matrix A DataFrame.
#' @return A DataFrame containing the ranking matrix.
#' @examples
#' df <- data.frame(
#' A=c(32, 52, 44, 44, 47),
#' B=c(73, 75, 65, 76, 70),
#' C=c(60, 59, 57, 55, 60),
#' D=c(35, 24, 44, 83, 47),
#' E=c(41, 52, 46, 50, 65))
#' 
#' utilsRankingMatrix(df)
utilsRankingMatrix <- function(data_matrix) {
    .Call(`_rSRD_utilsRankingMatrix`, data_matrix)
}

#' @title calculateSRDDistribution
#' @name calculateSRDDistribution
#' @aliases calculateSRDDistribution
#' @author Balázs R. Sziklai \email{sziklai.balazs@@krtk.hu}, Linus Olsson \email{linusmeol@@gmail.com}
#' @description R interface to calculate the SRD distribution that corresponds to the data. 
#' @param data_matrix A DataFrame.
#' @param option A char to specify how ties are generated in the simulation.
#'        The following options are available:
#'        \itemize{
#'        \item 'n': There are no ties for the solution vectors, the reference vector is fixed.
#'        \item 'r': There are no ties. Both the column vector and the reference are generated randomly.
#'        \item 't': Ties occur with a fixed probability specified by the user for both the solution vectors and the reference vector.
#'        \item 'p': Ties occur with a fixed probability specified by the user for the solution vectors, the reference vector is fixed.
#'        \item 'd': Tie distribution reflects the tie frequencies displayed by the solution vectors, the reference vector is fixed.
#'        \item As default (recommended): Tie distribution reflects the tie frequencies displayed in the reference, the reference vector is fixed.
#'        }
#' @param tie_probability The probability with which ties can occur.
#' @param output_to_file Boolean flag to enable file output.
#' @return A List containing the SRD distribution and related descriptive statistics. xx1 value 
#' indicates the 5 percent significance threshold. SRD values falling between xx1 and xx19 are not 
#' distinguishable from SRD scores of random rankings, while an SRD score higher than xx19 indicates 
#' that the solution ranks the objects in a reverse order (with 5 percent significance). 
#' @examples
#' \donttest{
#' df <- data.frame(
#' A=c(32, 52, 44, 44, 47),
#' B=c(73, 75, 65, 76, 70),
#' C=c(60, 59, 57, 55, 60),
#' D=c(35, 24, 44, 83, 47),
#' E=c(41, 52, 46, 50, 65))
#' 
#' calculateSRDDistribution(df, option = 'p', tie_probability = 0.5)
#' }
calculateSRDDistribution <- function(data_matrix, option = 'f', tie_probability = 0, output_to_file = FALSE) {
    .Call(`_rSRD_calculateSRDDistribution`, data_matrix, option, tie_probability, output_to_file)
}

#' @title calculateSRDValues
#' @name calculateSRDValues
#' @aliases calculateSRDValues
#' @author Balázs R. Sziklai \email{sziklai.balazs@@krtk.hu}, Linus Olsson \email{linusmeol@@gmail.com}
#' @description R interface to calculate SRD values.
#' To test the results' significance run calculateSRDDistribution(). 
#' For more information about SRD scores and their validation 
#' see Héberger and Kollár-Hunek (2011).
#' @param data_matrix A DataFrame.
#' @param output_to_file Boolean flag to enable file output.
#' @return A vector containing the SRD values.
#' @references Héberger K., Kollár-Hunek K. (2011) 
#' "Sum of ranking differences for method discrimination and its validation:
#' comparison of ranks with random numbers", Journal of Chemometrics, 25(4), pp. 151–158.
#' @examples
#' df <- data.frame(
#' A=c(32, 52, 44, 44, 47),
#' B=c(73, 75, 65, 76, 70),
#' C=c(60, 59, 57, 55, 60),
#' D=c(35, 24, 44, 83, 47),
#' E=c(41, 52, 46, 50, 65))
#' 
#' calculateSRDValues(df)
calculateSRDValues <- function(data_matrix, output_to_file = FALSE) {
    .Call(`_rSRD_calculateSRDValues`, data_matrix, output_to_file)
}

