% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_voxels.R
\name{plot_voxels}
\alias{plot_voxels}
\title{Plot Method for Voxels}
\usage{
plot_voxels(
  voxels,
  add.points = TRUE,
  add.voxels = TRUE,
  border = TRUE,
  points.size = 1,
  points.col = "black",
  fill.col = "forestgreen",
  line.lwd = 0.5,
  line.col = "black",
  alpha = 0.1,
  ...
)
}
\arguments{
\item{voxels}{Object of class \code{"voxels"} from \code{\link{voxels}}.}

\item{add.points}{Logical, if \code{TRUE} it adds the original points used to perform the voxelization. \code{TRUE} as default.}

\item{add.voxels}{Logical, if \code{TRUE} it adds the voxels created. \code{TRUE} as default.}

\item{border}{Logical, if \code{TRUE} it adds a line on the borders of each voxel. \code{TRUE} as default.}

\item{points.size}{The points size, a positive number to use if plot \code{add.points = TRUE}.}

\item{points.col}{A \code{character} defining the color of the points to use.}

\item{fill.col}{A \code{character} vector defining the color to fill the voxels, it could be a range of colors or a solid color.}

\item{line.lwd}{The line width, a positive number, defaulting to 0.5.}

\item{line.col}{A \code{character} defining the color of the border lines to use.}

\item{alpha}{A positive numeric vector describing the transparency of the voxels to fill. This value most be between 0.0 (fully transparent) .. 1.0 (opaque).}

\item{...}{General arguments passed to \code{\link{rgl}}.}
}
\value{
A 3D plot of a point cloud and voxels.
}
\description{
The \code{plot} method for objects of class \code{"voxels"} created using the \code{\link{voxels}} function.
}
\examples{
data("pc_tree")

###Create cubes of a size of 7x7x3.5.
vox <- voxels(pc_tree, edge_length = c(7, 7, 3.5))
plot_voxels(vox)

}
\seealso{
\code{\link{voxels}}, \code{\link{voxels_counting}}, \code{\link{summary_voxels}}
}
\author{
J. Antonio Guzmán Q.
}
