% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclidean_distance.R
\name{euclidean_distance}
\alias{euclidean_distance}
\title{Euclidean Distance Between 3D points}
\usage{
euclidean_distance(point, cloud, threads = 1L)
}
\arguments{
\item{point}{A \code{numeric} vector of length three describing the *XYZ* coordinates.}

\item{cloud}{A \code{data.table} with *XYZ* coordinates in the first three columns representing a point cloud.}

\item{threads}{An \code{integer} specifying the number of threads to use for parallel processing. Experiment to see what works best for your data on your hardware.}
}
\value{
A \code{numeric} vector describing of \code{point} to each row of \code{cloud}.
}
\description{
Estimate the distance between a point and a group of point.
}
\examples{
data("pc_tree")

euclidean_distance(point = c(0, 0, 0), pc_tree)

}
\author{
J. Antonio Guzmán Q.
}
