% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_mesh.R
\name{export_mesh}
\alias{export_mesh}
\title{Export Mesh}
\usage{
export_mesh(
  cylinder,
  filename,
  radius = NULL,
  cyl_color = NULL,
  cyl_palette = NULL,
  cyl_sides = 8
)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{filename}{Desired name of file. The .ply extension is automatically added.}

\item{radius}{Vector of cylinder radii. Defaults to modified cylinders from the cylinder data frame.}

\item{cyl_color}{Optional cylinder color parameter. Colors must be a single hex color, or a vector or column of hex colors with the same length as the cylinder data frame.}

\item{cyl_palette}{Optional color palette for numerical data. Palettes include: viridis, inferno, plasma, magma, cividis, and rainbow.}

\item{cyl_sides}{The number of sides in the polygon cross section. Defaults to 8, but can be increased to improve visual smoothness.}
}
\value{
A mesh .ply file
}
\description{
Exports QSM cylinder mesh using the rgl library
}
\examples{
\donttest{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)

filename <- tempfile(pattern = "QSM_mesh")
export_mesh(cylinder, filename)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder2 <- read.csv(file)
cylinder2 <- update_cylinders(cylinder2)

filename2 <- tempfile(pattern = "QSM_mesh2")
export_mesh(cylinder2, filename2)

## All Parameters

filename3 <- tempfile(pattern = "QSM_mesh3")
export_mesh(
  cylinder = cylinder,
  filename = filename3,
  radius = cylinder$UnmodRadius,
  cyl_color = cylinder$GrowthLength,
  cyl_palette = "viridis"
)

}

}
