% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_qsm.R
\name{import_qsm}
\alias{import_qsm}
\title{Import TreeQSM}
\usage{
import_qsm(file, version = "2.x.x")
}
\arguments{
\item{file}{a TreeQSM .mat MATLAB file}

\item{version}{TreeQSM version. Defaults to 2.x.x. The user can also specify the 2.0 format.}
}
\value{
Returns a list
}
\description{
Imports a QSM created by TreeQSM
}
\examples{

## Read a TreeQSM MATLAB file in the 2.3.x - 2.4.x format
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file, version = "2.x.x")
summary(qsm)

## Read a TreeQSM MATLAB file in the 2.0 format
file <- system.file("extdata/QSM_2.mat", package = "rTwig")
qsm <- import_qsm(file, version = "2.0")
names(qsm)

}
\references{
\insertRef{TreeQSM}{rTwig}
}
