% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcvp_match_fuzzy.R
\name{wcvp_match_fuzzy}
\alias{wcvp_match_fuzzy}
\alias{phonetic_match}
\alias{edit_match}
\title{Fuzzy (approximate) matching to the WCVP.}
\usage{
wcvp_match_fuzzy(names_df, wcvp_names, name_col, progress_bar = TRUE)

phonetic_match(names_df, wcvp_names, name_col)

edit_match(names_df, wcvp_names, name_col)
}
\arguments{
\item{names_df}{Data frame of names for matching.}

\item{wcvp_names}{Data frame of taxonomic names from WCVP version 7 or later.
If \code{NULL} (the default), names will be loaded from \href{https://matildabrown.github.io/rWCVPdata/}{\code{rWCVPdata::wcvp_names}}.}

\item{name_col}{Character. The column in \code{names_df} that has the taxon name
for matching.}

\item{progress_bar}{Logical. Show progress bar when matching? Defaults to
\code{TRUE}; should be changed to \code{FALSE} if used in a markdown report.}
}
\value{
Match results from WCVP bound to the original data from \code{names_df}.
}
\description{
Fuzzy matching to names in the WCVP using phonetic matching and edit distance.
The WCVP can be loaded for matching from \href{https://matildabrown.github.io/rWCVPdata/}{rWCVPdata::wcvp_names}.
}
\details{
The \code{wcvp_match_fuzzy} function uses phonetic matching first and then finds
the closest match based on edit distance for any remaining names.

Phonetic matching uses \link[phonics:metaphone]{phonics::metaphone} encoding with a maximum
code length of 20.

Edit distance matching finds the closest match based on Levenshtein similarity,
calculated by \link[RecordLinkage:strcmp]{RecordLinkage::levenshteinSim}.
}
\examples{
\donttest{ # this example requires 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
wcvp_names <- rWCVPdata::wcvp_names
wcvp_match_fuzzy(redlist_example, wcvp_names, "scientificName")
}
}

\donttest{ # this example requires 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
wcvp_names <- rWCVPdata::wcvp_names
phonetic_match(redlist_example, wcvp_names, "scientificName")
}
}

\donttest{ # this example requires 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
wcvp_names <- rWCVPdata::wcvp_names
edit_match(redlist_example, wcvp_names, "scientificName")
}
}

}
\seealso{
Other name matching functions: 
\code{\link{wcvp_match_exact}()},
\code{\link{wcvp_match_names}()}
}
\concept{name matching functions}
