% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestocolors.R
\name{codes_to_colors}
\alias{codes_to_colors}
\title{Converting numeric ID codes to listed color name codes}
\usage{
codes_to_colors(codes, available.colors = NULL)
}
\arguments{
\item{codes}{a list or matrix of numeric ID sequences generated by \code{\link{rs_IDs}}, \code{\link{brute_IDs}}, etc.}

\item{available.colors}{a list of strings that contains the names of the unique markings which compose the given 'alphabet' (e.g. "blue", "red", "yellow", etc.). The length of this list must match the 'alphabet size' used to generate the input \code{codes}.}
}
\value{
a list of unique, named codes that fit the provided parameters.
}
\description{
This is a helper function that transforms a list numeric ID sequences into a list of human-readable sequences. Sequences of 1s, 2s, and 3s can become sequences of "red"s, "blue"s, and "yellow"s, etc.
}
\examples{
total.length <- 3  #we have three positions to mark,
redundancy <- 1    #we want codes robust to a single erasure,
alphabet <- 3      #and we currently have three types of paint in stock

 #Create a list of codes
codes <- rs_IDs(total.length, redundancy, alphabet)

 #Let's make those into human-readable color sequences
color.names <- c("blue","red","pink-striped-orange")
codes_to_colors(codes, color.names)

 #We can also skip the whole function and plug the names straight into the code generator
rs_IDs(total.length, redundancy, alphabet, available.colors = color.names)


}
\author{
Andrew Burchill, \email{andrew.burchill@asu.edu}
}
