% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radiant.R
\name{get_data}
\alias{get_data}
\title{Select variables and filter data}
\usage{
get_data(
  dataset,
  vars = "",
  filt = "",
  arr = "",
  rows = NULL,
  data_view_rows = NULL,
  na.rm = TRUE,
  envir = c()
)
}
\arguments{
\item{dataset}{Dataset or name of the data.frame}

\item{vars}{Variables to extract from the data.frame}

\item{filt}{Filter to apply to the specified dataset}

\item{arr}{Expression to use to arrange (sort) the specified dataset}

\item{rows}{Select rows in the specified dataset}

\item{data_view_rows}{Vector of rows to select. Only used by Data > View in Radiant. Users should use "rows" instead}

\item{na.rm}{Remove rows with missing values (default is TRUE)}

\item{envir}{Environment to extract data from}
}
\value{
Data.frame with specified columns and rows
}
\description{
Select variables and filter data
}
\details{
Function is used in radiant to select variables and filter data based on user input in string form
}
\examples{
get_data(mtcars, vars = "cyl:vs", filt = "mpg > 25")
get_data(mtcars, vars = c("mpg", "cyl"), rows = 1:10)
get_data(mtcars, vars = c("mpg", "cyl"), arr = "desc(mpg)", rows = 1:5)
}
