% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ann.R
\name{predict.ann}
\alias{predict.ann}
\title{Predict method for the ann function}
\usage{
\method{predict}{ann}(object, pred_data = "", pred_cmd = "",
  conf_lev = 0.95, se = FALSE, dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{ann}}}

\item{pred_data}{Provide the name of a dataframe to generate predictions (e.g., "titanic"). The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Generate predictions using a command. For example, `pclass = levels(pclass)` would produce predictions for the different levels of factor `pclass`. To add another variable use a `,` (e.g., `pclass = levels(pclass), age = seq(0,100,20)`)}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{se}{Logical that indicates if prediction standard errors should be calculated (default = FALSE)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the ann function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/ann.html} for an example in Radiant
}
\examples{
result <- ann("titanic", "survived", c("pclass","sex"), lev = "Yes")
predict(result, pred_cmd = "pclass = levels(pclass)")
result <- ann("diamonds", "price", "carat:color", type = "regression")
predict(result, pred_cmd = "carat = 1:3")
predict(result, pred_data = "diamonds") \%>\% head

}
\seealso{
\code{\link{ann}} to generate the result

\code{\link{summary.ann}} to summarize results
}
