% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{predict.nn}
\alias{predict.nn}
\title{Predict method for the nn function}
\usage{
\method{predict}{nn}(object, pred_data = NULL, pred_cmd = "",
  dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{nn}}}

\item{pred_data}{Provide the dataframe to generate predictions (e.g., diamonds). The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Generate predictions using a command. For example, `pclass = levels(pclass)` would produce predictions for the different levels of factor `pclass`. To add another variable, create a vector of prediction strings, (e.g., c('pclass = levels(pclass)', 'age = seq(0,100,20)')}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the nn function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/nn.html} for an example in Radiant
}
\examples{
result <- nn(titanic, "survived", c("pclass", "sex"), lev = "Yes")
predict(result, pred_cmd = "pclass = levels(pclass)")
result <- nn(diamonds, "price", "carat:color", type = "regression")
predict(result, pred_cmd = "carat = 1:3")
predict(result, pred_data = diamonds) \%>\% head()

}
\seealso{
\code{\link{nn}} to generate the result

\code{\link{summary.nn}} to summarize results
}
